function [devValue,gradient]=Deviance(Z,p,distn,link,n,m,V,A,k,y,G,model)
%This function calculates the value of the deviance function and its first derivative
c=Z(1);
index=2;
MainEffects=cell(m,1);
for j=1:m
    MainEffects{j}=A{j}*Z(index:index+k(j)-2);
    index=index+k(j)-1;
end
if model==7
    Y=cell(m,m);
    for i=1:m
        for j=1:m
            if i<j
                if V(i,j)
                    Y{i,j}=Z(index:index+(k(i)-1)*(k(j)-1)-1);
                    Y{i,j}=A{i}*reshape(Y{i,j},[k(i)-1 k(j)-1])*A{j}';
                else
                    Y{i,j}=zeros(k(i),k(j));
                end
                index=index+(k(i)-1)*(k(j)-1);
            end
        end
    end
elseif model~=1
    Y=cell(m,1);
    GY=cell(m,1);
    for j=1:m
        for z=1:p
            Y{j}(:,z)=A{j}*Z(index:index+k(j)-2);
            index=index+k(j)-1;
        end
        GY{j}=G{j}*Y{j};
    end
    if model==2 || model==4
        S=zeros(m);
        for i=1:m
            for j=i+1:m
                S(i,j)=Z(index);
                index=index+1;
            end
        end
        S=0.5*(S+S');
    elseif model==3
        S=zeros(m,m,p);
        for i=1:m
            for j=i+1:m
                for l=1:p
                    S(i,j,l)=Z(index);
                    index=index+1;
                end
            end
        end
        for i=1:p
            S(:,:,i)=0.5*(S(:,:,i)+S(:,:,i)');
        end
    elseif model==5
        S=diag(Z(index:index+p-1));
    end
end
% Fill yMain with main effects
yMain = zeros(n,m);
for j=1:m
    yMain(:,j)=yMain(:,j)+G{j}*MainEffects{j};
end
% Fill yInt with interaction effects
yInt = zeros(n,m,m);
if model==2 || model==4
    for i=1:m
        for j=i+1:m
            if V(i,j)
                yInt(:,i,j) = S(i,j)*sum((GY{i}).*(GY{j}),2);
                yInt(:,j,i)=yInt(:,i,j);
            end
        end
    end
elseif model==3
    for i=1:m
        for j=i+1:m
            if V(i,j)
                yInt(:,i,j) = (GY{i}.*GY{j})*squeeze(S(i,j,:));
                yInt(:,j,i)=yInt(:,i,j);
            end
        end
    end
elseif model==5
    for i=1:m-1
        for j=i+1:m
            if V(i,j)
                yInt(:,i,j) = (GY{i}.*GY{j})*diag(S);
            end
        end
    end    
elseif model==6
    for i=1:m-1
        for j=i+1:m
            if V(i,j)
                yInt(:,i,j)=sum(GY{i}.*GY{j},2);
            end
        end
    end
elseif model==7
    for i=1:m
        for j=1:m
            if i<j
                yInt(:,i,j) = V(i,j)*sum((G{i}*Y{i,j}).*(G{j}),2);
            end
        end
    end
end
if ischar(link)
    linkinfo=['l',link];               %the file containing link info
    power=1;
else
    linkinfo='lpower';                 %link info if a power link is used
    power=link;
end
distinfo=['d',distn];                 %the file containing distribution info
mBinom=length(y);
eta=c+sum(yMain,2)+sum(sum(yInt,3),2);
mu=min(feval(linkinfo,eta,power,'mu'),10^250);
devValue=feval(distinfo,2,y,mu,mBinom,ones(n,1));
if nargout>1 %Calculate analytical gradient
    gradient=zeros(n,size(Z,1));
    gradient(:,1)=1;
    index=2;
    GA=cell(m,1);
    for i=1:m
        GA{i}=G{i}*A{i};
    end
    for j=1:m
        gradient(:,index:index+k(j)-2)=GA{j};
        index=index+k(j)-1;
    end
    if model==2 || model==4
        for i=1:m
            Yfixed = zeros(n,p);
            for j=1:m
                if V(i,j)
                    Yfixed = Yfixed+2*S(i,j)*GY{j};
                end
            end
            for l=1:p
                gradient(:,index:index+k(i)-2)=((Yfixed(:,l)*ones(1,k(i))).*G{i})*A{i};
                index=index+k(i)-1;
            end
        end
        for i=1:m-1
            for j=i+1:m
                gradient(:,index) =V(i,j)*sum(GY{i}.*GY{j},2);
                index=index+1;
            end
        end
    elseif model==3
        for i=1:m
            Yfixed = zeros(n,p);
            for j=1:m
                if V(i,j)
                    vector=squeeze(S(i,j,:))'+squeeze(S(j,i,:))';
                    Yfixed = Yfixed+(ones(n,1)*vector).* GY{j};
                end
            end
            for l=1:p
                gradient(:,index:index+k(i)-2)=((Yfixed(:,l)*ones(1,k(i))).*G{i})*A{i};
                index=index+k(i)-1;
            end
        end
        for i=1:m-1
            for j=i+1:m
                if V(i,j)
                    gradient(:,index:index+p-1) =GY{i}.*GY{j};
                end
                index=index+p;
            end
        end    
    elseif model==5
        for i=1:m
            Yfixed = zeros(n,p);
            for j=1:m
                if V(i,j)
                    Yfixed = Yfixed+GY{j}*S;
                end
            end
            for l=1:p
                gradient(:,index:index+k(i)-2)=((Yfixed(:,l)*ones(1,k(i))).*G{i})*A{i};
                index=index+k(i)-1;
            end
        end
        for l=1:p
            for i=1:m-1
                for j=i+1:m
                    gradient(:,index)=gradient(:,index)+GY{i}(:,l).*GY{j}(:,l);                    
                end
            end
            index=index+1;
        end
    elseif model==6
        for i=1:m
            Yfixed = zeros(n,p);
            for j=1:m
                if V(i,j)
                    Yfixed = Yfixed+GY{j};
                end
            end
            for l=1:p
                gradient(:,index:index+k(i)-2)=((Yfixed(:,l)*ones(1,k(i))).*G{i})*A{i};
                index=index+k(i)-1;
            end
        end
    elseif model==7
        for i=1:m-1
            for j=i+1:m
                if V(i,j)
                    for zz=1:k(j)-1
                        gradient(:,index:index+k(i)-2)=(GA{i}).*(GA{j}(:,zz)*ones(1,k(i)-1));
                        index=index+k(i)-1;
                    end
                else
                    for zz=1:k(j)-1
                        gradient(:,index:index+k(i)-2)=0;
                        index=index+k(i)-1;
                    end
                end
            end
        end
    end
    if  strcmp(distn,'normal')
        gradient=(2*(mu-y)./feval(linkinfo,mu,power,'detadmu'))'*gradient;
    elseif strcmp(distn,'poisson')
        mu=max(mu,10^-250);
        gradient=((2*(y.*-1./mu +1)) ./feval(linkinfo,mu,power,'detadmu'))'*gradient;
    else
        dy_dmu=zeros(n,1);
        for i=1:n
            dy_dmu(i)=50000*(feval(distinfo,2,y(i),mu(i)+.00001,mBinom,1)-feval(distinfo,2,y(i),mu(i)-.00001,mBinom,1));
        end
        gradient=(dy_dmu./feval(linkinfo,mu,power,'detadmu'))'*gradient;
    end
end